/*
 * definitions for dealing with Agents
 */

#include "lf_fms_comm.h"
#include "lf_fma_comm.h"

/*
 * Definitions
 */

#define FMS_FMA_FIRST_CONNECT_CHECK_DELAY 15000

/*
 * FMA-related info
 */
struct fms_fma_info {
  char **preferred_mappers;	/* array of pointers to preferred mappers */
  int num_pref_mappers;
};

/*
 * data for handling an agent
 */
struct fms_fma_desc {

  struct fms_connection *fcp;		/* connection for this agent */
  struct lf_channel *chp;		/* FMS channel */

  /* incoming message buffers */
  struct fms_msg_header header;
  void *adp_msgbuf;
  int adp_msgbuf_size;

  int needs_map;			/* TRUE if needs topo map */
  int needs_link_state;			/* TRUE if needs topo link state */

  struct fms_proxy_server_info *proxy;	/* proxy information for this host */
  struct fms_fma_desc *proxy_clients;	/* hosts for which this is server */

  /* information about the node */
  char hostname[LF_STRING_LEN];
  struct lf_host *fabric_host;
};

/*
 * Information on how to reach this FMA through a proxy
 */
struct fms_proxy_server_info {
  int proxy_client_id;			/* ID for this client */

  struct fms_fma_desc *server;		/* this FMA's proxy server */

  /* How to reach this FMA through proxy server */
  int nic_index;
  int port;
  unsigned char route[MYRI_MAX_ROUTE_LEN];
  int route_len;

  /* List of other FMAs which share same proxy server */
  struct fms_fma_desc *next_proxy_peer;
  struct fms_fma_desc *prev_proxy_peer;
};

/*
 * prototypes
 */
int init_fma_vars(void);
int init_fma(void);
int init_fma_connection(struct fms_connection *fcp);
struct lf_host *fms_add_new_host(char *hostname);
void disconnect_from_fma(struct fms_fma_desc *acp);
void fms_fma_alert_no_initial_fma(struct lf_host *hp);
void fms_fma_alert_lost_fma(struct lf_host *hp);
void fms_fma_alert_present(struct lf_host *hp);
void fms_fma_alert_sram_parity_error(struct lf_host *hp, int nic_id);
void fms_fma_alert_nic_died(struct lf_host *hp, int nic_id);
void fms_fma_alert_nic_badcrc(struct lf_nic *nicp, int port, int badcrcs);
void fms_fma_alert_unrecognized_nic_type(struct lf_host *hp, int nic_id,
  lf_string_t product_id);
void fms_fma_alert_nic_port_down(struct lf_nic *nicp, int port);
void fms_fma_alert_nic_port_up(struct lf_nic *nicp, int port);
void fms_fma_terminate(struct fms_fma_desc *adp, lf_string_t reason);
int fms_fma_write(struct fms_fma_desc *, int type, void *buf, int len);
int fms_send_topo_map(struct lf_fabric *fp, struct fms_fma_desc *adp);
int fms_send_topo_link_state(struct lf_fabric *fp, struct fms_fma_desc *adp);
int fms_send_topo_map_to_all_needy_fma(struct lf_fabric *fp);
struct lf_nic *fms_add_nic(struct lf_host *hp, struct fma_fms_nic *nip);
void fms_remove_nic(struct lf_nic *nicp);
struct lf_nic *fms_change_nic(struct lf_nic *nicp, struct fma_fms_nic *nip);
void fms_fma_invalidate_map(void);
void fms_fma_invalidate_link_state(struct lf_fabric *fp);
void fms_fma_needs_topo_map(struct fms_fma_desc *adp);
void fms_reconcile_link_info(struct lf_host *hp, struct fma_fms_host_msg *hmp);
void fms_fma_changed_link(struct lf_nic *nicp, int port,
                          struct fma_fms_nic *nip);
void fms_fma_missing_link(struct lf_nic *nicp, int port);
void fms_fma_new_link_by_xid(struct lf_nic *nicp, int port,
    			     int xbar_id, int xbar_port);
void fms_schedule_map_request(void);
int fms_map_request_pending(void);
void fms_clear_all_verifies(void);
void fms_stop_fabric_resolution();
void fms_remove_all_proxy_clients(struct fms_fma_desc *sadp);
void fms_fma_proxy_message(struct fms_fma_desc *padp,
			   struct lf_proxy_fma_to_fms *msg);
void fms_handle_message(struct fms_fma_desc *adp, int type, int length,
			union fma_fms_msg *msg);
void fms_proxy_write(struct fms_fma_desc *cadp, int type,
		     void *buf, int length);
